package ie.ucd.sixth.adaptor.wasp;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import ie.ucd.sixth.core.adaptor.AbstractSensorNetworkAdaptor;
import ie.ucd.sixth.core.adaptor.IMessageTranslator;
import ie.ucd.sixth.core.adaptor.SensorMessageTranslationException;
import ie.ucd.sixth.core.misc.IConnectivityReceiver;
import ie.ucd.sixth.core.misc.TaskingMessage;
import ie.ucd.sixth.core.sensor.SensorNodeDescription;
import ie.ucd.sixth.core.sensor.SensorDescription;
import ie.ucd.sixth.core.sensor.SensorMessage;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import ie.ucd.sixth.core.sensor.data.Modality;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

import org.osgi.framework.BundleContext;

public class WaspmoteAdaptor extends AbstractSensorNetworkAdaptor implements
		IConnectivityReceiver, SerialPortEventListener {

	private int baudRate = 38400;
	private BufferedReader inStream;

	public WaspmoteAdaptor(BundleContext bundleContext) {
		this.baudRate = 38400;
		initialize("waspmote");
	}
	
	@Override
	public void setNodeTypes(){
		String type = getName();
		SensorNodeDescription desc = new SensorNodeDescription(000, type);
		desc.addSensor(new SensorDescription(Modality.ACCELERATION_X, 000, type));
		desc.addSensor(new SensorDescription(Modality.ACCELERATION_Y, 000, type));
		desc.addSensor(new SensorDescription(Modality.ACCELERATION_Z, 000, type));
		desc.addSensor(new SensorDescription(Modality.TEMPERATURE, 000, type));
		desc.addSensor(new SensorDescription(Modality.LIGHT, 000, type));
		desc.addSensor(new SensorDescription(new Modality("Battery"), 000, type));
		desc.addSensor(new SensorDescription(Modality.ACCELERATION_X_RATE, 000, type));
		desc.addSensor(new SensorDescription(Modality.ACCELERATION_Y_RATE, 000, type));
		desc.addSensor(new SensorDescription(Modality.ACCELERATION_Z_RATE, 000, type));
		desc.addSensor(new SensorDescription(Modality.TEMPERATURE_RATE, 000, type));
		desc.addSensor(new SensorDescription(Modality.LIGHT_RATE, 000, type));
		desc.addSensor(new SensorDescription(new Modality("Battery"+".rate"), 000, type));
		nodeTypeMap.put(type+".sensor", desc);
	}
	


	public void setSerialReader(InputStream is) {
		inStream = new BufferedReader(new InputStreamReader(is));
	}

	@Override
	public void serialEvent(SerialPortEvent event) {

		switch (event.getEventType()) {
		case SerialPortEvent.BI:
		case SerialPortEvent.CD:
		case SerialPortEvent.CTS:
		case SerialPortEvent.DSR:
		case SerialPortEvent.FE:
		case SerialPortEvent.OE:
		case SerialPortEvent.PE:
		case SerialPortEvent.RI:
		case SerialPortEvent.OUTPUT_BUFFER_EMPTY:
			break;
		case SerialPortEvent.DATA_AVAILABLE:
			try {
				IMessageTranslator<String> translator = new WaspMessageTranslator();
				List<ISensorData> data = translator.translateMessage(inStream.readLine().toString());
				for (ISensorData iSensorData : data) {
					addData(iSensorData);
				}
			} catch (IOException e) {
				e.printStackTrace();
			} catch (SensorMessageTranslationException e) {
				e.printStackTrace();
			}
			break;
		default:
			break;
		}
	}

	@Override
	public boolean task(TaskingMessage message) {
		return false;
	}

	@Override
	public void accept(SensorMessage visitor) {
		SensorMessage message = (SensorMessage) visitor;
		String address = message.getSensor();
		if (isWasp(address)) {
			System.out.println("Waspmote " + visitor.getSensor());
			CommPortIdentifier portId;
			try {
				portId = CommPortIdentifier.getPortIdentifier(address);
				new SerialProgram(portId, baudRate, this);
			} catch (NoSuchPortException e) {
				e.printStackTrace();
			}
		}

	}

	public static boolean isWasp(String path) {
		String os = System.getProperty("os.name");
		if (os.startsWith("Mac")) {
			return path.startsWith("/dev/tty.usbserial");
		} else {
			return false;
		}
	}
}
